﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace MemoQServicesClient
{
    public partial class LanguageSettingForm : Form
    {
        public LanguageSettingForm()
        {
            InitializeComponent();
        }

        private void btnAdd_Click( object sender, EventArgs e )
        {
            if ( tbLang.Text != "" )
                listLang.Items.Add( tbLang.Text );
        }

        private void btnRemove_Click( object sender, EventArgs e )
        {
            if ( listLang.SelectedItem != null )
                listLang.Items.Remove( listLang.SelectedItem );
        }

        public string[] Languages
        {
            get
            {
                if ( listLang.Items.Count == 0 )
                    return new string[] { };
                else
                {
                    string[] lang = new string[listLang.Items.Count];
                    for ( int i = 0; i < listLang.Items.Count; i++ )
                        lang[i] = listLang.Items[i] as string;
                    return lang;
                }
            }
        }

        private void btnOk_Click( object sender, EventArgs e )
        {
            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        private void btnCancel_Click( object sender, EventArgs e )
        {
            this.DialogResult = DialogResult.Cancel;
            this.Close();
        }
    }
}
