﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace MemoQServicesClient.TB
{
    public partial class CreateQTermFromMultitermForm : Form
    {
        public CreateQTermFromMultitermForm()
        {
            InitializeComponent();
        }

        public string QTermName
        {
            get { return txtName.Text; }
        }
        public string FilePath
        {
            get { return txtInputPath.Text; }
        }
        public bool Underscorize
        {
            get { return chkBoxUnderscorize.Checked; }
        }
        public bool ExpandPickLists
        {
            get { return chkBoxExpandPickLists.Checked; }
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            using (var ofd = new OpenFileDialog())
            {
                ofd.CheckFileExists = true;
                ofd.Filter = "ZIP file|*.zip";
                if (ofd.ShowDialog() == DialogResult.OK)
                {
                    txtInputPath.Text = ofd.FileName;
                }
            }
        }

        private void btnImport_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            this.Close();
        }
    }
}
