﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace MemoQServicesClient.TM
{
    public partial class LookupForm : Form
    {
        public LookupForm()
        {
            InitializeComponent();
        }

        public IEnumerable<MemoQServicesClient.TMService.TMInfo> TMList
        {
            set
            {
                lbTMList.Items.Clear();
                foreach( var tm in value )
                    lbTMList.Items.Add( tm );
                if( lbTMList.Items.Count > 0 )
                    lbTMList.SelectedIndex = 0;
            }
        }

        public Guid TMGuid
        {
            get { return ( (MemoQServicesClient.TMService.TMInfo)lbTMList.SelectedItem ).Guid; }
        }

        public string SegmentText
        {
            get { return txtText.Text; }
        }

        private void lbTMList_SelectedIndexChanged( object sender, EventArgs e )
        {
            btnOK.Enabled = lbTMList.SelectedItem != null;
        }
    }
}
