﻿using System.Collections.Generic;
using System.ServiceModel;

namespace DummyTMInterface
{
    /// <summary>
    /// The interface of the dummy TM service.
    /// </summary>
    [ServiceContract]
    public interface ITMService
    {
        /// <summary>
        /// The dummy TM service's login method.
        /// </summary>
        /// <param name="userName">The user name.</param>
        /// <param name="password">The password.</param>
        /// <returns>The token code.</returns>
        [OperationContract]
        string Login(string userName, string password);

        /// <summary>
        /// Lists the supported languages of the dummy TM service.
        /// </summary>
        /// <param name="tokenCode">The token code.</param>
        /// <returns>The list of the supported languages.</returns>
        [OperationContract]
        List<string> ListSupportedLanguages(string tokenCode);

        /// <summary>
        /// Gets the possible translations for a single string from the translation memory.
        /// </summary>
        /// <param name="tokenCode">The token code.</param>
        /// <param name="input">The string to translate.</param>
        /// <param name="srcLangCode">The source language code.</param>
        /// <param name="trgLangCode">The target language code.</param>
        /// <returns>The possible translations of the input string.</returns>
        [OperationContract]
        TMServiceLookupHit[] Lookup(string tokenCode, string input, string srcLangCode, string trgLangCode);

        /// <summary>
        /// Gets the possible concordance lookup results of specific texts.
        /// </summary>
        /// <param name="tokenCode">The token code.</param>
        /// <param name="texts">The texts sent for concordance.</param>
        /// <param name="srcLangCode">The source language code.</param>
        /// <param name="trgLangCode">The target language code.</param>
        /// <param name="caseSensitive">The case sensitivity.</param>
        /// <param name="numericEquivalence">Numeric equivalence.</param>
        /// <param name="limit">The maximum number of total concordance results.</param>
        /// <param name="totalResultCount">The total number of concordance results.</param>
        /// <returns>The concordance results of the texts.</returns>
        [OperationContract]
        TMServiceConcordanceItem[] Concordance(string tokenCode, string[] texts, string srcLangCode, string trgLangCode, bool caseSensitive, bool numericEquivalence, int limit, out int totalResultCount);
    }
}
