﻿using MemoQ.TMInterfaces;

namespace TestClient
{
    /// <summary>
    /// Contains information about a single plugin
    /// </summary>
    internal class PluginInfo
    {
        /// <summary>
        /// The plugin director of the plugin.
        /// </summary>
        private PluginDirectorBase director;

        public PluginInfo(PluginDirectorBase director)
        {
            this.director = director;
        }

        /// <summary>
        /// Gets the director of the plugin.
        /// </summary>
        public PluginDirectorBase Director
        {
            get { return director; }
        }

        public override string ToString()
        {
            return director.FriendlyName;
        }
    }
}
