﻿using MemoQ.TBInterfaces;

namespace DummyTBPlugin
{
    class DummyTBEngine : EngineBase
    {
        private readonly string targetLangCode;
        private readonly string sourceLangCode;

        public DummyTBEngine(string sourceLangCode, string targetLangCode)
        {
            this.sourceLangCode = sourceLangCode;
            this.targetLangCode = targetLangCode;
        }

        /// <summary>
        /// Creates a session that performs the actual translations.
        /// </summary>
        /// <returns>The created session</returns>
        public override ISession CreateSession()
        {
            return new DummyTBSession(sourceLangCode, targetLangCode);
        }

        public override void Dispose()
        { }
    }
}
