﻿using System.Drawing;
using System.Reflection;
using System.Windows.Forms;
using MemoQ.Addins.Common.Framework;
using MemoQ.Addins.Common.Utils;
using MemoQ.TBInterfaces;

namespace DummyTBPlugin
{
    class DummyTBPluginDirector : PluginDirectorBase
    {
        /// <summary>
        /// The identifier of the plugin.
        /// </summary>
        public const string PluginId = "DummyTBPlugin";

        public override IEnvironment Environment
        {
            set
            {
                base.Environment = value;

                // initialize the localization helper
                LocalizationHelper.Instance.SetEnvironment(value);

                EnvironmentProvider.Environment = value;
            }
        }

        public override bool IsActivated
        {
            get { return true; }
        }

        public override void Initialize(IModuleEnvironment env)
        { }

        public override void Cleanup()
        { }

        public override bool PluginConfigured
        {
            get { return DummyTBSettings.PluginIsConfigured; }
        }

        public override bool PluginEnabled
        {
            get
            {
                return DummyTBSettings.Instance.PluginEnabled;
            }
            set
            {
                if (DummyTBSettings.Instance.PluginEnabled != value)
                {
                    DummyTBSettings.Instance.PluginEnabled = value;
                    DummyTBSettings.Instance.SaveSettings();

                    environment.PluginAvailabilityChanged();
                }
            }
        }

        public override bool IsLanguagePairSupported(string srcLangName, string trgLangName)
        {
            return DummyTBSettings.PluginIsConfigured &&
                DummyTBSettings.Instance.SupportedLanguages.Contains(srcLangName) &&
                DummyTBSettings.Instance.SupportedLanguages.Contains(trgLangName);
        }

        public override System.Drawing.Image DisplayIcon
        {
            get { return Image.FromStream(Assembly.GetExecutingAssembly().GetManifestResourceStream("DummyTBPlugin.Icon.bmp")); }
        }

        public override string FriendlyName
        {
            get { return LocalizationHelper.Instance.GetResourceString("FriendlyName"); }
        }

        public override string PluginID
        {
            get { return PluginId; }
        }

        public override string CopyrightText
        {
            get { return LocalizationHelper.Instance.GetResourceString("CopyrightText"); }
        }

        public override void ShowOptionsForm(System.Windows.Forms.Form parentForm)
        {
            using (DummyTBOptionsForm form = new DummyTBOptionsForm())
            {
                if (form.ShowDialog(parentForm) == DialogResult.OK)
                {
                    environment.PluginAvailabilityChanged();
                }
            }
        }

        public override IEngine CreateEngine(string srcLangName, string trgLangName)
        {
            return new DummyTBEngine(srcLangName, trgLangName);
        }

        public override bool SupportsAddingNewTerms
        {
            get { return true; }
        }

        public override string GetAddTermsUrl(string externalId, string sourceLang, string sourceTerm, string targetLang, string targetTerm)
        {
            return "http://dummytbservice.com/addterms?id=" +
                HttpUtility.UrlEncode(externalId) +
                "&sourceLang=" +
                HttpUtility.UrlEncode(sourceLang) +
                "&sourceTerm=" +
                HttpUtility.UrlEncode(sourceTerm) +
                "&targetLang=" +
                HttpUtility.UrlEncode(targetLang) +
                "&targetTerm=" +
                HttpUtility.UrlEncode(targetTerm);
        }

        public override bool SupportsModifyingExistingTerms
        {
            get { return true; }
        }

        public override string GetModifyTermsUrl(string externalId)
        {
            return "http://dummytbservice.com/modifyterm?id=" + HttpUtility.UrlEncode(externalId);
        }
    }
}
