﻿using System;
using MemoQ.Addins.Common.DataStructures;
using MemoQ.TBInterfaces;

namespace DummyTBPlugin
{
    class DummyTBSession : SessionBase
    {
        private readonly string targetLangCode;
        private readonly string sourceLangCode;

        public DummyTBSession(string sourceLangCode, string targetLangCode)
        {
            this.sourceLangCode = sourceLangCode;
            this.targetLangCode = targetLangCode;
        }

        public override TerminologyResult[] Lookup(Segment segment)
        {
            try
            {
                return DummyTBService.Instance.Lookup(segment, targetLangCode).ToArray();
            }
            catch (Exception e)
            {
                throw new TBAddinException(string.Format(LocalizationHelper.Instance.GetResourceString("UnexpectedError"), e.Message),
                    string.Format("An unexpected error occured ({0})", e.Message), e);
            }
        }

        public override void Dispose()
        { }
    }
}
