﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace MemoQServicesClient
{
    public enum NameSettingMode
    {
        User,
        Group
    }

    public partial class NameSettingForm : Form
    {
        public string name;
        public NameSettingForm(NameSettingMode mode)
        {
            InitializeComponent();
            switch (mode)
            {
                case NameSettingMode.User:
                    lblName.Text = "User name:";
                    break;
                case NameSettingMode.Group:
                    lblName.Text = "Group name:";
                    break;
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (tbName.Text == string.Empty)
            {
                MessageBox.Show("Name is empty", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            else
            {
                name = tbName.Text;
                DialogResult = DialogResult.OK;
                Close();
            }
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }
    }
}
