﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace MemoQServicesClient
{
    public enum SettingsMode
    {
        User,
        UserAndGroups,
        Group,
        GroupAndUsers,
        Object,
        ObjectAndUsers
    }

    public partial class ParameterSettingsForm : Form
    {
        public Guid guid = Guid.Empty;
        public Guid[] guids;

        public ParameterSettingsForm(SettingsMode mode)
        {
            InitializeComponent();
            switch (mode)
            {
                case SettingsMode.User:
                    lblGuid1.Text = "User Guid:";
                    lblGuid2.Visible = false;
                    tbGuid2.Enabled = false;
                    lbGuids.Enabled = false;
                    btnAdd.Enabled = false;
                    btnRemove.Enabled = false;
                    break;
                case SettingsMode.UserAndGroups:
                    lblGuid1.Text = "User Guid:";
                    lblGuid2.Text = "Group Guids:";
                    break;
                case SettingsMode.Group:
                    lblGuid1.Text = "Group Guid:";
                    lblGuid2.Visible = false;
                    tbGuid2.Enabled = false;
                    lbGuids.Enabled = false;
                    btnAdd.Enabled = false;
                    btnRemove.Enabled = false;
                    break;
                case SettingsMode.GroupAndUsers:
                    lblGuid1.Text = "Group Guid:";
                    lblGuid2.Text = "User Guids:";
                    break;
                case SettingsMode.Object:
                    lblGuid1.Text = "Object Guid:";
                    lblGuid2.Visible = false;
                    tbGuid2.Enabled = false;
                    lbGuids.Enabled = false;
                    btnAdd.Enabled = false;
                    btnRemove.Enabled = false;
                    break;
                case SettingsMode.ObjectAndUsers:
                    lblGuid1.Text = "Object Guid:";
                    lblGuid2.Text = "User or Group Guids:";
                    break;
            }
        }

        private void tbGuid1_Leave(object sender, EventArgs e)
        {
            if (tbGuid1.Text != string.Empty)
            {
                try
                {
                    guid = new Guid(tbGuid1.Text);
                }
                catch (Exception)
                {
                    MessageBox.Show("Guid is incorrect", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            if (tbGuid2.Text != string.Empty)
            {
                Guid guid = Guid.Empty;
                try
                {
                    guid = new Guid(tbGuid2.Text);
                }
                catch (Exception)
                {
                    MessageBox.Show("Guid is incorrect", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    return;
                }
                if (!lbGuids.Items.Contains(guid)) lbGuids.Items.Add(guid);
            }
        }

        private void btnRemove_Click(object sender, EventArgs e)
        {
            for (int i = 0; i < lbGuids.SelectedItems.Count; i++)
            {
                lbGuids.Items.Remove(lbGuids.SelectedItems[i]);
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (guid == Guid.Empty)
            {
                MessageBox.Show("Guid is empty", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            if (lbGuids.Enabled)
            {
                if (lbGuids.Items.Count == 0)
                {
                    MessageBox.Show("Guid list is empty", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    return;
                }
                guids = new Guid[lbGuids.Items.Count];
                for (int i = 0; i < lbGuids.Items.Count; i++)
                {
                    guids[i] = (Guid)(lbGuids.Items[i]);
                }
            }
            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

    }
}
