﻿using System;
using System.Collections.Generic;
using System.Text;
using MemoQServicesClient.TMService;

namespace MemoQServicesClient.TMService
{
    public partial class ResourceInfo
    {

        public ResourceInfo(Guid guid, string name, string description, bool isReadonly)
        {
            this.Guid = guid;
            this.Name = name;
            this.Description = description;
            this.Readonly = isReadonly;
        }

        public override string ToString()
        {
            return
                string.Format("Guid: {0}\nName: {1}\nDescription: {2}\nReadonly: {3}\n",
                Guid, Name, Description, Readonly);
        }
    }

    public partial class HeavyResourceInfo
    {
        public HeavyResourceInfo(Guid guid, string name, string description, bool isReadonly)
            : base(guid, name, description, isReadonly)
        {
            this.Guid = guid;
            this.Name = name;
            this.Description = description;
            this.Readonly = isReadonly;
        }

        public HeavyResourceInfo(Guid guid, string name, string description, bool isReadonly,
            string domain, string subject, string client, string project) :
            this(guid, name, description, isReadonly)
        {
            this.Domain = domain;
            this.Subject = subject;
            this.Client = client;
            this.Project = project;
        }

        public override string ToString()
        {
            return
                string.Format("Guid: {0}\nName: {1}\nDescription: {2}\nReadonly: {3}\nDomain: {4}\nSubject: {5}\nProject: {6}\nClient: {7}\n",
                Guid, Name, Description, Readonly, Domain, Subject, Client, Project);
        }

    }

    public partial class TMInfo
    {
        public TMInfo(Guid guid, string name, string description, bool isReadonly,
            bool storeFormatting, bool allowMultiple, bool useContext,
            string sourceLanguageCode, string targetLanguageCode)
            :
            base(guid, name, description, isReadonly)
        {
            this.StoreFormatting = storeFormatting;
            this.AllowMultiple = allowMultiple;
            this.UseContext = useContext;
            this.SourceLanguageCode = sourceLanguageCode;
            this.TargetLanguageCode = targetLanguageCode;
        }

        public override string ToString()
        {
            return
                string.Format("{0}StoreFormatting: {1}\nAllowMultiple: {2}\nUseContext: {3}\nSourceLanguageCode: {4}\nTargetLanguageCode: {5}",
                    base.ToString(), StoreFormatting, AllowMultiple, UseContext, SourceLanguageCode, TargetLanguageCode);
        }

        public static string CollectionToString(IEnumerable<TMInfo> infos)
        {
            StringBuilder sb = new StringBuilder();
            if (infos != null)
            {
                foreach (TMInfo info in infos)
                {
                    sb.AppendLine(info.ToString());
                    sb.AppendLine("----------------------------------------------------");
                }
            }
            return sb.ToString();
        }
    }
}

namespace MemoQServicesClient.TBService
{
    public partial class ResourceInfo
    {
        public ResourceInfo()
        {
        }

        public ResourceInfo(Guid guid, string name, string description, bool isReadonly)
        {
            this.Guid = guid;
            this.Name = name;
            this.Description = description;
            this.Readonly = isReadonly;
        }

        public override string ToString()
        {
            return
                string.Format("Guid: {0}\nName: {1}\nDescription: {2}\nReadonly: {3}\n",
                Guid, Name, Description, Readonly);
        }
    }

    public partial class HeavyResourceInfo
    {
        public HeavyResourceInfo(Guid guid, string name, string description, bool isReadonly)
            : base(guid, name, description, isReadonly)
        {
            this.Guid = guid;
            this.Name = name;
            this.Description = description;
            this.Readonly = isReadonly;
        }

        public HeavyResourceInfo(Guid guid, string name, string description, bool isReadonly,
            string domain, string subject, string client, string project) :
            this(guid, name, description, isReadonly)
        {
            this.Domain = domain;
            this.Subject = subject;
            this.Client = client;
            this.Project = project;
        }

        public override string ToString()
        {
            return
                string.Format("Guid: {0}\nName: {1}\nDescription: {2}\nReadonly: {3}\nDomain: {4}\nSubject: {5}\nProject: {6}\nClient: {7}\n",
                Guid, Name, Description, Readonly, Domain, Subject, Client, Project);
        }

    }

    public partial class TBInfo
    {
        public TBInfo(Guid guid, string name, string description, bool isReadonly,
            string[] languages)
            :
            base(guid, name, description, isReadonly)
        {
            if (languages == null)
                this.LanguageCodes = new string[0];
            else
            {
                this.LanguageCodes = new string[languages.Length];
                Array.Copy(languages, this.LanguageCodes, languages.Length);
            }
        }

        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append(base.ToString());
            sb.Append("\nIsModareated: "); sb.Append(this.IsModerated);
            sb.Append("\nLanguages: ");

            bool isFirst = true;
            foreach (string lang in this.LanguageCodes)
            {
                if (isFirst)
                    isFirst = false;
                else
                    sb.Append(", ");

                sb.Append(lang);
            }
            return sb.ToString();
        }

        public static string CollectionToString(IEnumerable<TBInfo> infos)
        {
            StringBuilder sb = new StringBuilder();
            if (infos != null)
            {
                foreach (TBInfo info in infos)
                {
                    sb.AppendLine(info.ToString());
                    sb.AppendLine("----------------------------------------------------");
                }
            }
            return sb.ToString();
        }
    }

}

namespace MemoQServicesClient.SecurityService
{
    public partial class UserInfo
    {
        public UserInfo(Guid userGuid, string userName, string password, bool isDisabled, string fullName,
            string address, string emailAddress, string phoneNumber, string mobilePhoneNumber)
        {
            this.UserGuid = userGuid;
            this.UserName = userName;
            this.Password = password;
            this.IsDisabled = isDisabled;
            this.FullName = fullName;
            this.Address = address;
            this.EmailAddress = emailAddress;
            this.PhoneNumber = phoneNumber;
            this.MobilePhoneNumber = mobilePhoneNumber;
        }

        public static string CollectionToString(IEnumerable<UserInfo> infos)
        {
            StringBuilder sb = new StringBuilder();
            if (infos != null)
            {
                foreach (UserInfo info in infos)
                {
                    sb.AppendLine(info.ToString());
                    sb.AppendLine("----------------------------------------------------");
                }
            }
            return sb.ToString();
        }

        public override string ToString()
        {
            return
                string.Format("UserGuid: {0}\nUserName: {1}\nPassword: {2}\nIsDisabled: {3}\nFullName: {4}\nAddress: {5}\nEmailAddress: {6}\nPhoneNumber: {7}\nMobilePhoneNumber: {8}",
                    UserGuid, UserName,
                    "****", // For security reasons we don't display the pw hash
                    IsDisabled, FullName, Address, EmailAddress, PhoneNumber, MobilePhoneNumber);
        }
    }

    public partial class GroupInfo
    {
        public GroupInfo(Guid groupGuid, string groupName, string description, bool isDiabled)
        {
            this.GroupGuid = groupGuid;
            this.GroupName = groupName;
            this.Description = description;
            this.IsDisabled = isDiabled;
        }

        public static string CollectionToString(IEnumerable<GroupInfo> infos)
        {
            StringBuilder sb = new StringBuilder();
            if (infos != null)
            {
                foreach (GroupInfo info in infos)
                {
                    sb.AppendLine(info.ToString());
                    sb.AppendLine("----------------------------------------------------");
                }
            }
            return sb.ToString();
        }

        public override string ToString()
        {
            return string.Format("GroupGuid: {0}\nGroupName: {1}\nDescription: {2}\nIsDisabled: {3}",
                GroupGuid, GroupName, Description, IsDisabled);
        }
    }

    public partial class ObjectPermission
    {
        public ObjectPermission(Guid guidOfUserOrGroup, int permissionId, DateTime expirationDate)
        {
            this.GuidOfUserOrGroup = guidOfUserOrGroup;
            this.PermissionId = permissionId;
            this.ExpirationDate = expirationDate;
        }

        public static string CollectionToString(IEnumerable<ObjectPermission> infos)
        {
            StringBuilder sb = new StringBuilder();
            if (infos != null)
            {
                foreach (ObjectPermission info in infos)
                {
                    sb.AppendLine(info.ToString());
                    sb.AppendLine("----------------------------------------------------");
                }
            }
            return sb.ToString();
        }

        public override string ToString()
        {
            return string.Format("GuidOfUserOrGroup: {0}\nPermissionId: {1}\nExpirationDate: {2}",
                GuidOfUserOrGroup, PermissionId, ExpirationDate);
        }
    }
}
