﻿using System;

namespace DummyTMInterface
{
    /// <summary>
    /// This class represents a specific result of the concordance operation.
    /// </summary>
    public class TMServiceConcordanceItem
    {
        /// <summary>
        /// This class represents a range information.
        /// </summary>
        public class TMServiceConcordanceRangeInfo
        {
            /// <summary>
            /// The starting index of a specific text sent for concordance in the source segment of a concordance item.
            /// </summary>
            public int Start { get; set; }

            /// <summary>
            /// The length of a specific text sent for concordance in the source segment of a concordance item.
            /// </summary>
            public int Length { get; set; }
        }

        /// <summary>
        /// An array of range infos for a concordance item.
        /// </summary>
        public TMServiceConcordanceRangeInfo[] RangeInfos { get; set; }

        /// <summary>
        /// The source string.
        /// </summary>
        public string SourceString { get; set; }

        /// <summary>
        /// The target string.
        /// </summary>
        public string TargetString { get; set; }

        /// <summary>
        /// The last modification date of the translation.
        /// </summary>
        public DateTime LastModified { get; set; }

        /// <summary>
        /// The translation last modified by.
        /// </summary>
        public string UserName { get; set; }

        /// <summary>
        /// The creation date of the TM hit.
        /// </summary>
        public DateTime CreationDate { get; set; }

        /// <summary>
        /// The translation's creating user.
        /// </summary>
        public string CreatingUser { get; set; }

        /// <summary>
        /// The subject of the translation.
        /// </summary>
        public string Subject { get; set; }

        /// <summary>
        /// The domain of the translation.
        /// </summary>
        public string Domain { get; set; }

        /// <summary>
        /// The document that contains the translation.
        /// </summary>
        public string Document { get; set; }
    }
}
