﻿using MemoQ.TMInterfaces;

namespace DummyTMPlugin
{
    /// <summary>
    /// Dummy TM engine for a particular language combination.
    /// </summary>
    public class DummyTMEngine : EngineBase
    {
        /// <summary>
        /// The source language.
        /// </summary>
        private readonly string srcLangCode;

        /// <summary>
        /// The target language.
        /// </summary>
        private readonly string trgLangCode;

        public DummyTMEngine(string srcLangCode, string trgLangCode)
        {
            this.srcLangCode = srcLangCode;
            this.trgLangCode = trgLangCode;
        }

        /// <summary>
        /// Creates a session for translating segments. Session will not be used in a multi-threaded way.
        /// </summary>
        public override ISession CreateSession()
        {
            return new DummyTMSession(srcLangCode, trgLangCode);
        }

        /// <summary>
        /// Disposes the resources used by the engine if needed.
        /// </summary>
        public override void Dispose()
        {
            // dispose your resources if needed
        }
    }
}
