﻿using System;
using System.ServiceModel;
using DummyTMInterface;

namespace DummyTMService
{
    class Program
    {
        static void Main(string[] args)
        {
            var baseAddress = new Uri("net.tcp://localhost:8733/TMService");

            using (var selfHost = new ServiceHost(typeof(TMService), baseAddress))
            {
                selfHost.AddServiceEndpoint(typeof(ITMService), new NetTcpBinding(), "DummyService");
                selfHost.Open();

                Console.WriteLine("Dummy WCF service is loaded on address " + selfHost.Description.Endpoints[0].Address + ". Press ENTER to exit.");
                Console.ReadLine();
            }
        }
    }
}
