﻿using System;
using MemoQ.Addins.Common.DataStructures;
using MemoQ.TMInterfaces;

namespace TestClient
{
    public class DummyEnvironment : IEnvironment
    {
        /// <summary>
        /// The main form of the test client.
        /// </summary>
        private MainForm form;

        public DummyEnvironment(MainForm form)
        {
            this.form = form;
        }

        #region IEnvironment Members

        /// <summary>
        /// The UI language code of the application.
        /// </summary>
        public string UILang
        {
            get { return "eng"; }
        }

        /// <summary>
        /// Handles the plugin availability changed events.
        /// </summary>
        public void PluginAvailabilityChanged()
        {
            form.UpdateControls();
        }

        /// <summary>
        /// Parse the string for a TMX segment, i.e.: "<seg>...</seg>"
        /// </summary>
        public Segment ParseTMXSeg(string str)
        {
            return Segment.Empty;
        }

        /// <summary>
        /// Serialize the segment as a TMX segment, i.e.: "<seg>...</seg>"
        /// </summary>
        public string WriteTMXSeg(Segment seg)
        {
            return string.Empty;
        }

        /// <summary>
        /// Returns the localized text which is belonging to the specified key.
        /// If returns null the TM plugin should display its own default texts.
        /// </summary>
        public string GetResourceString(string pluginName, string key)
        {
            return null;
        }

        /// <summary>
        /// Analyze the segment and tokenize with word boundaries.
        /// </summary>
        public AnalyzedSegment BuildWordsOfSegment(Segment seg)
        {
            throw new NotImplementedException();
        }

        #endregion
    }
}
